import "./Contact.css";
import { useState } from "react";
import { Formik, Field, Form, ErrorMessage } from "formik";
import axios from "axios";
import * as Yup from "yup";

const Contact = ({ submitButtonRef, contactElement }) => {
  const initialValues = {
    firstName: "",
    email: "",
    phone: "",
    address: "",
  };

  const [showPopup, setShowPopup] = useState(false);

  const validationSchema = Yup.object({
    firstName: Yup.string().required("Full Name is required"),
    email: Yup.string()
      .email("Invalid email address")
      .required("Email is required"),
    phone: Yup.string().required("Phone number is required"),
    address: Yup.string().required("Address is required"),
  });

  const handleSubmit = async (values, { resetForm }) => {
    try {
      await axios.post("/api/send-email", values);
      setShowPopup(true);
      console.log(values);
      resetForm();
    } catch (error) {
      console.error("Error submitting form:", error);
    }
  };

  const handleOkButton = () => {
    setShowPopup(false);
    window.scrollTo({ top: 0, behavior: "smooth" });
  };

  return (
    <div className="contact_container">
      <Formik
        initialValues={initialValues}
        validationSchema={validationSchema}
        onSubmit={handleSubmit}
      >
        <Form>
          <div className="contact_titles" ref={submitButtonRef}>
            <h1 ref={contactElement}>
              Contact us now and we will help choose the right plan for you
            </h1>
            <p>
              Please note that the offers available for new subscribers only
            </p>
          </div>
          <div class="row">
            <div class="col">
              <Field
                type="text"
                id="firstName"
                name="firstName"
                placeholder="Name*"
                class="form-control"
              />
              {/* <ErrorMessage name="firstName" component="div" /> */}
            </div>
            <div class="col">
              <Field
                type="text"
                id="email"
                name="email"
                placeholder="Email address"
                class="form-control"
              />
              {/* <ErrorMessage name="email" component="div" /> */}
            </div>
          </div>
          <div class="row">
            <div class="col">
              <Field
                type="text"
                id="phone"
                name="phone"
                placeholder="Mobile number*"
                class="form-control"
              />
              {/* <ErrorMessage name="phone" component="div" /> */}
            </div>
            <div class="col">
              <Field
                type="text"
                id="address"
                name="address"
                placeholder="UAE district"
                class="form-control"
              />
              {/* <ErrorMessage name="address" component="div" /> */}
            </div>
          </div>

          <div className="contact_btn">
            <button type="submit">Submit</button>
          </div>
        </Form>
      </Formik>
      {showPopup && (
        <div className="thankyou_popup_main">
          <div className="thankyou_popup">
            <h1 className="popup_title">Form Submitted Successfully</h1>
            <p className="popup_text">We will be in touch with you shortly</p>
            <button className="popup_button" onClick={handleOkButton}>
              OK
            </button>
          </div>
        </div>
      )}
    </div>
  );
};

export default Contact;
