import nodemailer from "nodemailer";

export default async (req, res) => {
  if (req.method === "POST") {
    const { firstName, email, phone, address } = req.body;

    const transporter = nodemailer.createTransport({
      service: "webmail",
      host: "vps94614.inmotionhosting.com",
      port: 465,
      secure: true,
      auth: {
        user: process.env.EMAIL_USERNAME,
        pass: process.env.EMAIL_PASSWORD,
      },
    });

    const mailOptions = {
      from: email,
      to: "spoc@svtek.ae",
      subject: "New Contact Form Submission",
      text: `New Form Submission:
      Name: ${firstName}
      Phone Number: ${phone}
      Address: ${address}
      Email: ${email}`,
    };

    try {
      const emailResponse = await transporter.sendMail(mailOptions);
      res
        .status(200)
        .json({ message: "Email sent successfully", emailResponse });
    } catch (error) {
      console.error("Failed to send email", error);
      res
        .status(500)
        .json({ message: "Failed to send email", error: error.message });
    }
  } else {
    res.setHeader("Allow", ["POST"]);
    res.status(405).end(`Method ${req.method} Not Allowed`);
  }
};
